int ploadPin        = 8;  // Connects to Parallel load pin the 165
int clockEnablePin  = 9;  // Connects to Clock Enable pin the 165
int dataPin         = 11; // Connects to the Q7 pin the 165
int clockPin        = 12; // Connects to the Clock pin the 165

void setup()
{
  Serial.begin(9600);
  pinMode(ploadPin, OUTPUT);
  pinMode(clockEnablePin, OUTPUT);
  pinMode(clockPin, OUTPUT);
  pinMode(dataPin, INPUT);
}

void loop()
{
  int bitVal = digitalRead(dataPin);
  Serial.println(bitVal);
  for (int i = 1 ; i < 8 ; i++){
    digitalWrite(ploadPin, LOW); 
    shiftIn (dataPin, clockPin, MSBFIRST);
    digitalWrite(ploadPin, HIGH);
  }
   delay(1000);
}
read_shift_regs(){
  long bitVal;
  int bytesVal = 0;
  digitalWrite(clockEnablePin, HIGH);
  digitalWrite(ploadPin, LOW);
  delayMicroseconds(5);
  digitalWrite(ploadPin, HIGH);
  digitalWrite(clockEnablePin, LOW);

  for (int i = 0; i < DATA_WIDTH; i++)
  {
    bitVal = digitalRead(dataPin);
    bytesVal |= (bitVal << ((8 - 1) - i));
    digitalWrite(clockPin, HIGH);
    delayMicroseconds(1);
    digitalWrite(clockPin, LOW);
  }
  return (bytesVal);
}
