#include <SPI.h>
#include <Ethernet.h>
#include <Streaming.h>
#include <MemoryFree.h>
#include <SkaarhojPgmspace.h>
byte mac[] = {
  0x90, 0xA2, 0xDA, 0x0D, 0x6B, 0xB9
};      // <= SETUP!  MAC address of the Arduino
IPAddress clientIp(192, 168, 1, 239);
IPAddress switcherIp(192, 168, 1, 240); 
#include <ATEMbase.h>
#include <ATEMmin.h>
ATEMmin AtemSwitcher;

void setup() {
  for (int i=2;i<9;i++){
      pinMode(i, INPUT);
    };
  randomSeed(analogRead(5));
  Ethernet.begin(mac, clientIp);
  Serial.begin(9600);
  Serial << F("\n- - - - - - - -\nSerial Started\n");
  AtemSwitcher.begin(switcherIp);
  AtemSwitcher.serialOutput(2);
  AtemSwitcher.connect();
  Serial << F("freeMemory()=") << freeMemory() << "\n";
}
int pushButton = 0;
bool AtemOnline = false;
void loop() {
  AtemSwitcher.runLoop();
  //PVW
  pvwshow(4, 1);
  pvwshow(5, 2);
  pvwshow(6, 3);
  //PGM
  pgmshow(7, 1);
  pgmshow(8, 2);
  pgmshow(9, 3);
  //cut
  if (digitalRead(2)) {
    if (pushButton != 2) {
      pushButton = 2;
      Serial.println("CUT");
      AtemSwitcher.performCutME(0);
    }
  } else if (pushButton == 2) {
    pushButton = 0;
  }
  if (digitalRead(3)) {
    if (pushButton != 3) {
      pushButton = 3;
      Serial.println("AUTO");
      AtemSwitcher.performAutoME(0);
    }
  } else if (pushButton == 3) {
    pushButton = 0;
  }
  //MY CODE END
  delay(10);
}
//viod
//
//
void pvwshow(int8_t pin, int8_t in) {
  if (digitalRead(pin)) {
    if (pushButton != pin) {
      pushButton = pin;
      Serial.println("PVW: "+ in);
      AtemSwitcher.setPreviewInputVideoSource(0, in);
    }
  } else if (pushButton == pin) {
    pushButton = 0;
  }
}
void pgmshow(int8_t pin, int8_t in) {
  if (digitalRead(pin)) {
    if (pushButton != pin) {
      pushButton = pin;
      Serial.println("PVW: "+ in);
      AtemSwitcher.setProgramInputVideoSource(0, in);
    }
  } else if (pushButton == pin) {
    pushButton = 0;
  }
}