#include <SPI.h>
#include <Ethernet.h>
#include <Streaming.h>
//#include <MemoryFree.h>
#include <SkaarhojPgmspace.h>
byte mac[] = {0x90, 0xA2, 0xDA, 0x0D, 0x6B, 0xB9};
//MY IP
IPAddress clientIp(192, 168, 1, 239);
//CUT IP
IPAddress switcherIp(192, 168, 1, 240);
//keyboard
#include <ShiftIn.h>
ShiftIn<2> shift;
//LED
int dataPin = 6;
int latchPin = 7;
int clockPin = 8;
int LEDID[9][9] = {
  {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
  {0xff, 0x7f, 0x3f, 0x5f, 0x6f, 0x77, 0x7b, 0x7d, 0x7e},
  {0xff, 0x3f, 0xbf, 0x9f, 0xaf, 0xb7, 0xbb, 0xbd, 0xbe},
  {0xff, 0x5f, 0x9f, 0xdf, 0xcf, 0xd7, 0xdb, 0xdd, 0xde},
  {0xff, 0x6f, 0xaf, 0xcf, 0xef, 0xe7, 0xeb, 0xed, 0xee},
  {0xff, 0x77, 0xb7, 0xd7, 0xe7, 0xf7, 0xf3, 0xf5, 0xf6},
  {0xff, 0x7b, 0xbb, 0xdb, 0xeb, 0xf3, 0xfb, 0xf9, 0xfa},
  {0xff, 0x7d, 0xbd, 0xdd, 0xed, 0xf5, 0xf9, 0xfd, 0x7c},
  {0xff, 0x7e, 0xbe, 0xde, 0xee, 0xf6, 0xfa, 0x7c, 0xfe}
};
#include <ATEMbase.h>
#include <ATEMmin.h>
ATEMmin AtemSwitcher;
void setup() {
  randomSeed(analogRead(5));
  Ethernet.begin(mac, clientIp);
  Serial.begin(9600);
  //KEYBOARD PIN
  pinMode(A1, INPUT);
  pinMode(A2, INPUT);
  shift.begin(2, 3, 4, 5);
  //LED PIN
  pinMode(latchPin, OUTPUT);
  pinMode(clockPin, OUTPUT);
  pinMode(dataPin, OUTPUT);
  AtemSwitcher.begin(switcherIp);
  AtemSwitcher.serialOutput(2);
  AtemSwitcher.connect();
}
int mE = 0;//切换台编号
int BUTID = 0;//按钮复位
int nowPGM, nowPVW;
int oldPGM, oldPVW;
uint8_t oldpgmBUT, oldpvwBUT;
//int 8byte[9] = {"0","1","2","4","8","16","32","64","128"}
int butVS[9] = {0, 1, 2, 4, 8, 16, 32, 64, 128};
int getTALLYs = 0;
void loop() {
  //LOAD...
  AtemSwitcher.runLoop();
  //GET LED INFO
  nowPGM = AtemSwitcher.getProgramInputVideoSource(mE);
  nowPVW = AtemSwitcher.getPreviewInputVideoSource(mE);
  //ATUO LED
  if (AtemSwitcher.getTransitionInTransition(mE) != 1) {
    if (nowPGM != oldPGM || nowPVW != oldPVW) {
      setTALLY(nowPGM, nowPGM, nowPVW, nowPVW);
    }
    oldPGM = nowPGM;
    oldPVW = nowPVW;
  } else {
    setTALLY(nowPGM, nowPVW, 0, 0);
  }
  //BUTTON
  if (shift.update()) {
    uint16_t getBUT = shift.read();
    uint8_t pgmBUT = (uint8_t)(getBUT >> 8);
    uint8_t pvwBUT = (uint8_t)getBUT;
    //PGM BUTTON
    if (pgmBUT != butVS[nowPGM]) {
      switch (pgmBUT) {
        case 1:
          butPGM(pgmBUT, 1);
          break;
        case 2:
          butPGM(pgmBUT, 2);
          break;
        case 4:
          butPGM(pgmBUT, 3);
          break;
        case 8:
          butPGM(pgmBUT, 4);
          break;
        case 16:
          butPGM(pgmBUT, 5);
          break;
        case 32:
          butPGM(pgmBUT, 6);
          break;
        case 64:
          butPGM(pgmBUT, 7);
          break;
        case 128:
          butPGM(pgmBUT, 8);
          break;
      }
    }
    //PVW BUTTON
    if (pvwBUT != butVS[nowPVW]) {
      switch (pvwBUT) {
        case 1:
          butPVW(pvwBUT, 1);
          break;
        case 2:
          butPVW(pvwBUT, 2);
          break;
        case 4:
          butPVW(pvwBUT, 3);
          break;
        case 8:
          butPVW(pvwBUT, 4);
          break;
        case 16:
          butPVW(pvwBUT, 5);
          break;
        case 32:
          butPVW(pvwBUT, 6);
          break;
        case 64:
          butPVW(pvwBUT, 7);
          break;
        case 128:
          butPVW(pvwBUT, 8);
          break;
      }
    }
  }
    //MP 1
  if (digitalRead(A2)) {
    if (BUTID != A2) {
      BUTID = A2;
      AtemSwitcher.performFadeToBlackME(mE);
    }
  } else if (BUTID == A2) {
    BUTID = 0;
  }
  //auto
  if (digitalRead(A0)) {
    if (BUTID != A0) {
      BUTID = A0;
      AtemSwitcher.performAutoME(mE);
    }
  } else if (BUTID == A0) {
    BUTID = 0;
  }
  //cut
  if (digitalRead(A1)) {
    if (BUTID != A1) {
      BUTID = A1;
      AtemSwitcher.performCutME(mE);
    }
  } else if (BUTID == A1) {
    BUTID = 0;
  }
  delay(2);
}
//PGM BUTTOON
void butPGM(uint8_t pgmBUT, int in) {
  AtemSwitcher.setProgramInputVideoSource(mE, in);
  oldpgmBUT = pgmBUT;
}
//PVW BUTTON
void butPVW(uint8_t pvwBUT, int in) {
  AtemSwitcher.setPreviewInputVideoSource(mE, in);
  oldpvwBUT = pvwBUT;
}
//TALLY LED
void setTALLY(int a, int b, int c, int d) {
  digitalWrite(latchPin, LOW);
  shiftOut(dataPin, clockPin, LSBFIRST, LEDID[c][d]);//PVW
  shiftOut(dataPin, clockPin, LSBFIRST, LEDID[a][b]);//PGM
  digitalWrite(latchPin, HIGH);
  delay(1);
}
