/*
	My Bmd
*/
#include <SPI.h>
#include <Ethernet.h>
#include <Streaming.h>
#include <MemoryFree.h>
#include <SkaarhojPgmspace.h>
byte mac[] = {0x90, 0xA2, 0xDA, 0x0D, 0x6B, 0xB9};
//MY IP
IPAddress clientIp(192, 168, 1, 239);
//CUT IP
IPAddress switcherIp(192, 168, 1, 240);
//keyboard
//#include <ShiftIn.h>
//ShiftIn<2> shift;
//LED
int LEDDATA = 6;
int LEDLA = 7;
int LEDCLK = 8;
int LEDID[9][9] = {
  {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff},
  {0xff, 0x7f, 0x3f, 0x5f, 0x6f, 0x77, 0x7b, 0x7d, 0x7e},
  {0xff, 0x3f, 0xbf, 0x9f, 0xaf, 0xb7, 0xbb, 0xbd, 0xbe},
  {0xff, 0x5f, 0x9f, 0xdf, 0xcf, 0xd7, 0xdb, 0xdd, 0xde},
  {0xff, 0x6f, 0xaf, 0xcf, 0xef, 0xe7, 0xeb, 0xed, 0xee},
  {0xff, 0x77, 0xb7, 0xd7, 0xe7, 0xf7, 0xf3, 0xf5, 0xf6},
  {0xff, 0x7b, 0xbb, 0xdb, 0xeb, 0xf3, 0xfb, 0xf9, 0xfa},
  {0xff, 0x7d, 0xbd, 0xdd, 0xed, 0xf5, 0xf9, 0xfd, 0x7c},
  {0xff, 0x7e, 0xbe, 0xde, 0xee, 0xf6, 0xfa, 0x7c, 0xfe}
};
#include <ATEMbase.h>
#include <ATEMmin.h>
ATEMmin AtemSwitcher;
void setup() {
  randomSeed(analogRead(5));
  Ethernet.begin(mac, clientIp);
  Serial.begin(9600);
  //KEYBOARD PIN
  pinMode(A1, INPUT);
  pinMode(A2, INPUT);
  //shift.begin(2, 3, 4, 5);
  //LED PIN
  pinMode(LEDLA, OUTPUT);
  pinMode(LEDCLK, OUTPUT);
  pinMode(LEDDATA, OUTPUT);
  AtemSwitcher.begin(switcherIp);
  AtemSwitcher.serialOutput(2);
  AtemSwitcher.connect();
}
int mE = 0;//切换台编号
int BUTID = 0;//按钮复位
int NOWPGM, NOWPVW;
int oldPGM, oldPVW;
uint8_t oldPGMBUT, oldPVWBUT;
//int 8byte[9] = {"0","1","2","4","8","16","32","64","128"}
int butVS[9] = {0, 1, 2, 4, 8, 16, 32, 64, 128};
int getTALLYs = 0;
int testnum = 0;
int testnumold = 0;
int timess = 0;
void loop() {
  //LOAD...
  AtemSwitcher.runLoop();
  //GET LED INFO
  NOWPGM = AtemSwitcher.getProgramInputVideoSource(mE);
  NOWPVW = AtemSwitcher.getPreviewInputVideoSource(mE);
  //ATUO LED
  if (AtemSwitcher.getTransitionInTransition(mE) != 1) {
    if (NOWPGM != oldPGM || NOWPVW != oldPVW) {
      setTALLY(NOWPGM, NOWPGM, NOWPVW, NOWPVW);
    }
    oldPGM = NOWPGM;
    oldPVW = NOWPVW;
  } else {
    setTALLY(NOWPGM, NOWPVW, 0, 0);
  }
  if (timess > 1000) {
    if (testnum <= 8) {
      butPVW(1, testnum);
    }
    else {
      testnum = 1;
    }
    testnum++;
    timess = 0;
  }
  timess++;
  //BUTTON

  //cut
  delay(2);
}
//PGM BUTTOON
void butPGM(uint8_t pgmBUT, int in) {
  AtemSwitcher.setProgramInputVideoSource(mE, in);
  oldPGMBUT = pgmBUT;
}
//PVW BUTTON
void butPVW(uint8_t pvwBUT, int in) {
  AtemSwitcher.setPreviewInputVideoSource(mE, in);
  oldPVWBUT = pvwBUT;
}
//TALLY LED
void setTALLY(int a, int b, int c, int d) {
  digitalWrite(LEDLA, LOW);
  shiftOut(LEDDATA, LEDCLK, LSBFIRST, LEDID[c][d]);//PVW
  shiftOut(LEDDATA, LEDCLK, LSBFIRST, LEDID[a][b]);//PGM
  digitalWrite(LEDLA, HIGH);
  delay(1);
}
