#include <SPI.h>
#include <Ethernet.h>
#include <Streaming.h>
#include <MemoryFree.h>
#include <SkaarhojPgmspace.h>
byte mac[] = {0x90, 0xA2, 0xDA, 0x0D, 0x6B, 0xB9};
IPAddress clientIp(192, 168, 1, 239);
IPAddress switcherIp(192, 168, 1, 240);
//keyboard
#include <ShiftIn.h>
ShiftIn<2> shift;
//LED
int latchPin = 8;
int clockPin = 7;
int dataPin = 6;
unsigned char pvwID[9] = {B11111111, B11111110, B11111101, B11111011, B11110111, B11101111, B11011111, B10111111, B01111111};
#include <ATEMbase.h>
#include <ATEMmin.h>
ATEMmin AtemSwitcher;
void setup() {
  randomSeed(analogRead(5));
  Ethernet.begin(mac, clientIp);
  Serial.begin(9600);
  //keyboard
  shift.begin(2, 3, 4, 5);
  //led
  pinMode(latchPin, OUTPUT);
  pinMode(clockPin, OUTPUT);
  pinMode(dataPin, OUTPUT);
  pinMode(A1, INPUT);
  AtemSwitcher.begin(switcherIp);
  AtemSwitcher.serialOutput(2);//2
  AtemSwitcher.connect();
}
int mE = 0;//切换台编号
int butID = 0;//按钮复位
//PVW
int oldPVW = 0;
int nowPVW = 1;
//PGM
int oldPGM = 0;
int nowPGM = 1;
//
uint16_t butdata;
void loop() {
  AtemSwitcher.runLoop();
  //MY CODE END
  if (shift.update()) {
    uint16_t getData = shift.read();
    uint8_t pgmData = (uint8_t)(getData >> 8);
    uint8_t pvwData = (uint8_t)getData;//将数组分成2个部分
    if(pgmData != 0&&pgmData != oldPGM){
      Serial.println("PGM GO");
      Serial.println(pgmData);
        butPGM(pgmData, 1, 1);
        butPGM(pgmData,2, 2);
        butPGM(pgmData,4, 3);
        butPGM(pgmData,8, 4);
        butPGM(pgmData,16, 5);
        butPGM(pgmData,32, 6);
        butPGM(pgmData,64, 7);
        butPGM(pgmData,128, 8);
        Serial.println("PGM END");
    }
    if(pvwData != 0&&pvwData != oldPVW){ 
        Serial.println("PVW GO");
        butPVW(pvwData,1, 1);
        butPVW(pvwData,2, 2);
        butPVW(pvwData,4, 3);
        butPVW(pvwData,8, 4);
        butPVW(pvwData,16, 5);
        butPVW(pvwData,32, 6);
        butPVW(pvwData,64, 7);
        butPVW(pvwData,128, 8);
        Serial.println("PVW END");
      }
  }
  //cut
  if (digitalRead(A1)) {
    if (butID != A1) {
      butID = A1;
      getTALLY();
      AtemSwitcher.performCutME(mE);
      setPGM(nowPVW);
      setPVW(nowPGM);
    }
  } else if (butID == A1) {
    butID = 0;
  }

  delay(10);
}
//获得最新tally信息
void getTALLY (){
      nowPGM = AtemSwitcher.getProgramInputVideoSource(mE);delay(5);
      nowPVW = AtemSwitcher.getPreviewInputVideoSource(mE);delay(5);
  }
//按下直接开关
void butPGM(uint8_t pgmData,int but, int in) {
  if (pgmData == but) {
    AtemSwitcher.setProgramInputVideoSource(mE, in);
    oldPGM = pgmData;
    delay(1);
    setPGM(in);
  }
}
//设置直切指示灯
void setPGM(int i) {
  digitalWrite(latchPin, LOW);
  shiftOut(dataPin, clockPin, MSBFIRST, pvwID[i]);
  digitalWrite(latchPin, HIGH);
  delay(5);
}
//按下预览开关
void butPVW(uint8_t pvwData,int but, int in) {
  if (pvwData == but) {
    AtemSwitcher.setPreviewInputVideoSource(mE, in);
    oldPVW = pvwData;
    delay(1);
    setPVW(in);
  }
}
//预览指示灯
void setPVW(int i) {
  digitalWrite(latchPin, LOW);
  shiftOut(dataPin, clockPin, MSBFIRST, pvwID[i]);
  digitalWrite(latchPin, HIGH);
  delay(5);
}
