#include <SPI.h>
#include <Ethernet.h>
#include <Streaming.h>
//#include <MemoryFree.h>
#include <SkaarhojPgmspace.h>
byte mac[] = {0x90, 0xA2, 0xDA, 0x0D, 0x6B, 0xB9};
//MY IP
IPAddress clientIp(192, 168, 1, 239);
//CUT IP
IPAddress switcherIp(192, 168, 1, 240);
//keyboard
#include <ShiftIn.h>
ShiftIn<2> shift;
//LED
int dataPin = 6;
int latchPin = 7;
int clockPin = 8;
//SYSTEM ID
const int mE = 0; 
//LED LIGHT ID
const int LEDID[9][9] = {
    // 0    1     2     3     4     5     6     7     8     //
    {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff}, //0
    {0xff, 0x7f, 0x3f, 0x5f, 0x6f, 0x77, 0x7b, 0x7d, 0x7e}, //1
    {0xff, 0x3f, 0xbf, 0x9f, 0xaf, 0xb7, 0xbb, 0xbd, 0xbe}, //2
    {0xff, 0x5f, 0x9f, 0xdf, 0xcf, 0xd7, 0xdb, 0xdd, 0xde}, //3
    {0xff, 0x6f, 0xaf, 0xcf, 0xef, 0xe7, 0xeb, 0xed, 0xee}, //4
    {0xff, 0x77, 0xb7, 0xd7, 0xe7, 0xf7, 0xf3, 0xf5, 0xf6}, //5
    {0xff, 0x7b, 0xbb, 0xdb, 0xeb, 0xf3, 0xfb, 0xf9, 0xfa}, //6
    {0xff, 0x7d, 0xbd, 0xdd, 0xed, 0xf5, 0xf9, 0xfd, 0xfc}, //7
    {0xff, 0x7e, 0xbe, 0xde, 0xee, 0xf6, 0xfa, 0xfc, 0xfe}  //8
};
const int butVS[9] = {0, 1, 2, 4, 8, 16, 32, 64, 128};
unsigned long oldTIME, panelDEBUG;
unsigned long outTIME = 400;
unsigned long DEBUGTIME = 2000;
int BUTID = 0; 
const int MP1 = 3010;
const int theFTB = 0;
int nowPGM, nowPVW, nowAUTO, oldPGM, oldPVW;
int nowFTB = 1;
int nowFTBs = 1;
int getTALLYs = 0;
bool nowBUT = true;
bool FTBs = false;
bool DEBUGs = false;
#include <ATEMbase.h>
#include <ATEMstd.h>
ATEMstd AtemSwitcher;
void setup()
{
  randomSeed(analogRead(5));
  Ethernet.begin(mac, clientIp);
  Serial.begin(9600);
  //KEYBOARD PIN
  pinMode(A0, INPUT);
  pinMode(A1, INPUT);
  pinMode(A2, INPUT);
  pinMode(A3, INPUT);
  pinMode(A4, OUTPUT);
  pinMode(A5, OUTPUT);
  pinMode(9, OUTPUT);
  shift.begin(2, 3, 4, 5);
  //LED PIN
  pinMode(latchPin, OUTPUT);
  pinMode(clockPin, OUTPUT);
  pinMode(dataPin, OUTPUT);
  //CLASS a4 a5
  digitalWrite(A4, HIGH);//OFF
  digitalWrite(A5, HIGH);//OFF
  digitalWrite(9, HIGH);//OFF
  AtemSwitcher.begin(switcherIp);
  AtemSwitcher.serialOutput(2);
  AtemSwitcher.connect();
  oldTIME = millis();
  panelDEBUG = oldTIME;
}
void loop(){
  //PANEL DEBUG
  if (AtemSwitcher.panelDEBUG() == true){
      digitalWrite(A5, LOW);
      digitalWrite(A4, LOW);
      delay(200);
      digitalWrite(A5, HIGH);
      digitalWrite(A4, HIGH);
      delay(200);
  }
  //LOAD SYSTEM ...
  AtemSwitcher.runLoop();
  //GET LIGHT INFO
  nowPGM = AtemSwitcher.getProgramInputVideoSource(mE);
  nowPVW = AtemSwitcher.getPreviewInputVideoSource(mE);
  //Serial.println(nowPVW);
  //Serial.println("");
  //======================SET LIGHT=====================

  if (nowFTBs == 1){
    if (AtemSwitcher.getFadeToBlackStateInTransition(mE) == 1){
      if (digitalRead(A5) == HIGH){
        digitalWrite(A5, LOW); //FTB NO
      }
    }
    else{
      nowFTBs = 0;
      digitalWrite(A5, HIGH); //EXIT FTB OFF
    }
  }
  //FTB FLASH
 if(AtemSwitcher.getFadeToBlackStateFullyBlack(mE) == 1){
    if (millis() > (oldTIME + outTIME)){
      digitalWrite(A5, FTBs); 
      FTBs = !FTBs;
      oldTIME = millis();
    }
  }
  else {
    nowFTBs = 1;
  }

  //AUTO LIGHT
  if (AtemSwitcher.getTransitionInTransition(mE) == 1){
    if (nowPVW == MP1 && nowPGM == MP1){
      setTALLY(0, 0, 0, 0);
    }
    else if (nowPVW == MP1){
      digitalWrite(9, HIGH); //GREEN
      digitalWrite(A4, LOW);
      setTALLY(nowPGM, nowPGM, 0, 0);
      }
    else if (nowPGM == MP1){
      setTALLY(nowPVW, nowPVW, 0, 0);
      }
    else {
      setTALLY(nowPGM, nowPVW, 0, 0);//SET AUTO LIGHT
      }
  }
  else if (nowPVW == MP1 && nowPGM == MP1){
    digitalWrite(9, HIGH); //GREEN 
    digitalWrite(A4, LOW); 
    setTALLY(0, 0, 0, 0);
  }
  else if (nowPGM == MP1){
    digitalWrite(9, HIGH); //GREEN 
    digitalWrite(A4, LOW); 
    setTALLY(0, 0, nowPVW, nowPVW);
  }
  else if (nowPVW == MP1){
    digitalWrite(A4, HIGH);
    digitalWrite(9, LOW); //GREEN
    setTALLY(nowPGM, nowPGM, 0, 0);
  }
  else{
    digitalWrite(9, HIGH); //RED OFF
    digitalWrite(A4, HIGH); //GREEN 0FF
    if (nowPGM != oldPGM || nowPVW != oldPVW){
      setTALLY(nowPGM, nowPGM, nowPVW, nowPVW);//SET PGM AND PVW LIGHT
	  oldPGM = nowPGM;
	  oldPVW = nowPVW;
    }
  }

  //==================  BUTTON PGM AND PVW ========================//




  if (shift.update())
  {
    uint16_t getBUT = shift.read();
    uint8_t pgmBUT = (uint8_t)(getBUT >> 8);
    uint8_t pvwBUT = (uint8_t)getBUT;
    //PGM BUTTON
    if (pgmBUT != butVS[nowPGM])
    {
      switch (pgmBUT)
      {
      case 1:
        butPGM(1);
        break;
      case 2:
        butPGM(2);
        break;
      case 4:
        butPGM(3);
        break;
      case 8:
        butPGM(4);
        break;
      case 16:
        butPGM(5);
        break;
      case 32:
        butPGM(6);
        break;
      case 64:
        butPGM(7);
        break;
      case 128:
        butPGM(8);
        break;
      }
    }
    //PVW BUTTON
    if (pvwBUT != butVS[nowPVW])
    {
      switch (pvwBUT)
      {
      case 1:
        butPVW(1);
        break;
      case 2:
        butPVW(2);
        break;
      case 4:
        butPVW(3);
        break;
      case 8:
        butPVW(4);
        break;
      case 16:
        butPVW(5);
        break;
      case 32:
        butPVW(6);
        break;
      case 64:
        butPVW(7);
        break;
      case 128:
        butPVW(8);
        break;
      }
    }
  }



  //=======================MY BUTTON===========================


  //MP1
  if (digitalRead(A3)){
    if (BUTID != "butMP1" && nowBUT == true){
      BUTID = "butMP1";
      butPVW(3010);
    }else{
      nowBUT = false;
    }
  }
  else if (BUTID == "butMP1")
  {
    BUTID = 0;
    nowBUT = true;
  }


  //FTB
  if (digitalRead(A2))
  {
    if (BUTID != "butFTB" && nowBUT == true)
    {
      BUTID = "butFTB";
      AtemSwitcher.performFadeToBlackME(mE);
      nowFTBs = 1;
    }
    else
    {
      nowBUT = false;
    }
  }
  else if (BUTID == "butFTB")
  {
    BUTID = 0;
    nowBUT = true;
  }

  //AUTO
  if (digitalRead(A0))
  {
    if (BUTID != "butAUTO" && nowBUT == true)
    {
      BUTID = "butAUTO";
      AtemSwitcher.performAutoME(mE);
    }
    else
    {
      nowBUT = false;
    }
  }
  else if (BUTID == "butAUTO")
  {
    BUTID = 0;
    nowBUT = true;
  }

  //CUT
  if (digitalRead(A1))
  {
    if (BUTID != "butCUT" && nowBUT == true)
    {
      BUTID = "butCUT";
      AtemSwitcher.performCutME(mE);
    }
    else
    {
      nowBUT = false;
    }
  }
  else if (BUTID == "butCUT")
  {
    BUTID = 0;
    nowBUT = true;
  }
  //delay(2);
}
//PGM BUTTOON
void butPGM(int in)
{
  AtemSwitcher.setProgramInputVideoSource(mE, in);
}
//PVW BUTTON
void butPVW(int in)
{
  AtemSwitcher.setPreviewInputVideoSource(mE, in);
}
//TALLY LED
void setTALLY(int a, int b, int c, int d)
{
  digitalWrite(latchPin, LOW);
  shiftOut(dataPin, clockPin, LSBFIRST, LEDID[c][d]); //PVW
  shiftOut(dataPin, clockPin, LSBFIRST, LEDID[a][b]); //PGM
  digitalWrite(latchPin, HIGH);
  delay(1);
}