#include <SPI.h>
#include <Ethernet.h>
#include <Streaming.h>
#include <MemoryFree.h>
#include <SkaarhojPgmspace.h>
byte mac[] = {0x90, 0xA2, 0xDA, 0x0D, 0x6B, 0xB9};
IPAddress clientIp(192, 168, 1, 239);
IPAddress switcherIp(192, 168, 1, 240);
//keyboard
#include <ShiftIn.h>
ShiftIn<2> shift;
//LED
int dataPin = 6;
int latchPin = 7;
int clockPin = 8;
unsigned char pvwID[9] = {B11111111, B11111110, B11111101, B11111011, B11110111, B11101111, B11011111, B10111111, B01111111};
#include <ATEMbase.h>
#include <ATEMmin.h>
ATEMmin AtemSwitcher;
void setup() {
  randomSeed(analogRead(5));
  Ethernet.begin(mac, clientIp);
  Serial.begin(9600);
  //keyboard
  shift.begin(2, 3, 4, 5);
  //led
  pinMode(latchPin, OUTPUT);
  pinMode(clockPin, OUTPUT);
  pinMode(dataPin, OUTPUT);
  pinMode(A1, INPUT);
  AtemSwitcher.begin(switcherIp);
  AtemSwitcher.serialOutput(2);//2
  AtemSwitcher.connect();
}
int mE = 0;//切换台编号
int butID = 0;//按钮复位

int nowPGM = 1;
int nowPVW = 1;
uint8_t oldPGM = 0;
uint8_t oldPVW = 0;


//
uint16_t butdata;
void loop() {
  AtemSwitcher.runLoop();
  //MY CODE END
  if (shift.update()) {
    uint16_t getBUT = shift.read();
    uint8_t pgmBUT = (uint8_t)(getBUT >> 8);
    uint8_t pvwBUT = (uint8_t)getBUT;//将数组分成2个部分
    if(pgmBUT != 0 && pgmBUT != oldPGM){
      Serial.println("PGM GO");
      Serial.println(pgmBUT);
        butPGM(pgmBUT, 1, 1);
        butPGM(pgmBUT,2, 2);
        butPGM(pgmBUT,4, 3);
        butPGM(pgmBUT,8, 4);
        butPGM(pgmBUT,16, 5);
        butPGM(pgmBUT,32, 6);
        butPGM(pgmBUT,64, 7);
        butPGM(pgmBUT,128, 8);
        Serial.println("PGM END");
    }
    if(pvwBUT != 0 && pvwBUT != oldPVW){ 
        Serial.println("PVW GO");
        butPVW(pvwBUT,1, 1);
        butPVW(pvwBUT,2, 2);
        butPVW(pvwBUT,4, 3);
        butPVW(pvwBUT,8, 4);
        butPVW(pvwBUT,16, 5);
        butPVW(pvwBUT,32, 6);
        butPVW(pvwBUT,64, 7);
        butPVW(pvwBUT,128, 8);
        Serial.println("PVW END");
      }
  }
  //cut
  if (digitalRead(A1)) {
    if (butID != A1) {
      butID = A1;
      getTALLY();
      AtemSwitcher.performCutME(mE);
      setPGMLED(nowPVW);
      setPVWLED(nowPGM);
    }
  } else if (butID == A1) {
    butID = 0;
  }
  delay(10);
}
//获得最新tally信息
void getTALLY (){
      nowPGM = AtemSwitcher.getProgramInputVideoSource(mE);delay(2);
      nowPVW = AtemSwitcher.getPreviewInputVideoSource(mE);delay(2);
  }
//直切开关
void butPGM(uint8_t Data,int but, int in) {
  if (Data == but) {
    AtemSwitcher.setProgramInputVideoSource(mE, in);
    oldPGM = Data;
    delay(2);
    setPGMLED(in);
  }
}
//预览开关
void butPVW(uint8_t Data,int but, int in) {
  if (Data == but) {
    AtemSwitcher.setPreviewInputVideoSource(mE, in);
    oldPVW = Data;
    delay(2);
    setPVWLED(in);
  }
}
//直切指示灯
void setPGMLED(int i) {
  digitalWrite(latchPin, LOW);
  shiftOut(dataPin, clockPin, MSBFIRST, pvwID[oldPVW]);//PVW
  shiftOut(dataPin, clockPin, MSBFIRST, pvwID[i]);//PGM
  digitalWrite(latchPin, HIGH);
  delay(2);
}
void setPVWLED(int i) {
  digitalWrite(latchPin, LOW);
  shiftOut(dataPin, clockPin, MSBFIRST, pvwID[i]);//PVW
  shiftOut(dataPin, clockPin, MSBFIRST, pvwID[oldPGM]);//PGM
  digitalWrite(latchPin, HIGH);
  delay(2);
}
